using System;
using Server;
using Server.Items;
using Server.Mobiles;
using Xanthos.Interfaces;

namespace Xanthos.Evo
{
	public class RaelisDemonioEgg : BaseEvoEgg
	{
		public override IEvoCreature GetEvoCreature()
		{
			return new RaelisDemonio( "a daemon hatchling" );
		}

		[Constructable]
		public RaelisDemonioEgg() : base()
		{
			Name = "a daemon egg";
			HatchDuration = 0.01;		// 15 minutes
		}

		public RaelisDemonioEgg( Serial serial ) : base ( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int)0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}